﻿<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Business.Db" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Handel.Forms" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Dokumenty i zestawienie VAT zakupu</title>

    <script runat="server">
		    
        public enum WgOkresu {
            Wpływu = 0,
            Wystawienia = 1,
            [Caption("Zakupu/Operacji")]
            Operacji = 2
        }

        public enum SortowanieWg {
            NumerSystemowy = 0,
            NumerObcy = 1,
            DataWystawienia = 2,
            DataOtrzymania = 3,
            DataOperacji = 4,
        }

        public class ParametryBase : SerializableContextBase {
            public ParametryBase(Context cx)
                : base(cx) {
                int y = Date.Today.Year;
                int m = Date.Today.Month;
                Date from = m == 1 ? new Date(y-1,12,1) : new Date(y,m-1,1);
                Date to = from.LastDayMonth();
                okres = new FromTo(from, to);
            }

            WgOkresu wgOkresu = WgOkresu.Wpływu;

            DefinicjaStawkiVat[] definicjeStawekVAT = null;
			[Caption("Kolumny(stawki VAT)")]
			[Soneta.Tools.Priority(1)]
			[Required]
			public DefinicjaStawkiVat[] DefinicjeStawekVAT {
				get { return definicjeStawekVAT; }
				set { definicjeStawekVAT = value; }
			}

            [Priority(10)]
            [Caption("Wg daty")]
            public WgOkresu WgOkresu {
                get { return wgOkresu; }
                set {
                    wgOkresu = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            FromTo okres = FromTo.All;

            [Priority(20)]
            [Caption("Okres")]
            public FromTo Okres {
                get { return okres; }
                set {
                    if (value == FromTo.Empty)
                        value = FromTo.All;
                    okres = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            SortowanieWg sortowanieWg = SortowanieWg.NumerSystemowy;

            [Priority(60)]
            [Caption("Sortowanie wg")]
            public SortowanieWg SortowanieWg {
                get { return sortowanieWg; }
                set {
                    sortowanieWg = value;
                    OnChanged(EventArgs.Empty);
                }
            }
        }

        static ParametryBase parametry;

        [Context]
        public static ParametryBase Parametry {
            get { return parametry; }
            set { parametry = value; }
        }

        public class Total {
            readonly DokumentHandlowy dokument;
            
            public Total(DokumentHandlowy dokument) {
                this.dokument = dokument;
            }
            
            public DokumentHandlowy Dokument {
                get { return dokument; }
            }

            public enum ZwracanaSuma {
                Netto = 0,
                Vat = 1,
            }

            decimal ZwróćWartość(ZwracanaSuma zwracanaSuma, Percent procentStawki) {
                decimal suma = 0m;
                foreach (SumaVAT sv in dokument.SumyVAT) {
                    if (sv.Stawka.Procent != procentStawki) continue;
                    switch(zwracanaSuma) {
                        case ZwracanaSuma.Netto:
                            suma += sv.Suma.Netto;
                            break;
                        case ZwracanaSuma.Vat:
                            suma += sv.Suma.VAT;
                            break;
                    }
                }
                return suma;
            }

            decimal ZwróćWartość0() {
                decimal suma = 0m;
                HandelModule hm = HandelModule.GetInstance(dokument.Session);
                DefinicjaStawkiVat definicja = hm.Core.DefStawekVat.Zero;
                foreach (SumaVAT sv in dokument.SumyVAT) {
                    if (sv.DefinicjaStawki != definicja) continue;
                    suma += sv.Suma.Netto;
                }
                return suma;
            }

            decimal ZwróćWartośćNP() {
                decimal suma = 0m;
                HandelModule hm = HandelModule.GetInstance(dokument.Session);
                DefinicjaStawkiVat definicja = hm.Core.DefStawekVat.NiePodlega;
                foreach (SumaVAT sv in dokument.SumyVAT) {
                    if (sv.DefinicjaStawki != definicja) continue;
                    suma += sv.Suma.Netto;
                }
                return suma;
            }

            decimal ZwróćWartośćZW() {
                decimal suma = 0m;
                HandelModule hm = HandelModule.GetInstance(dokument.Session);
                DefinicjaStawkiVat definicja = hm.Core.DefStawekVat.WgKodu["ZW"];
                foreach (SumaVAT sv in dokument.SumyVAT) {
                    if (sv.DefinicjaStawki != definicja) continue;
                    suma += sv.Suma.Netto;
                }
                return suma;
            }

            public decimal Netto3 {
                get { return ZwróćWartość(ZwracanaSuma.Netto, new Percent(0.03m)); }
            }

            public decimal Vat3 {
                get { return ZwróćWartość(ZwracanaSuma.Vat, new Percent(0.03m)); }
            }

            public decimal Netto5 {
                get { return ZwróćWartość(ZwracanaSuma.Netto, new Percent(0.05m)); }
            }

            public decimal Vat5 {
                get { return ZwróćWartość(ZwracanaSuma.Vat, new Percent(0.05m)); }
            }

            public decimal Netto6 {
                get { return ZwróćWartość(ZwracanaSuma.Netto, new Percent(0.06m)); }
            }

            public decimal Vat6 {
                get { return ZwróćWartość(ZwracanaSuma.Vat, new Percent(0.06m)); }
            }

            public decimal Netto7 {
                get { return ZwróćWartość(ZwracanaSuma.Netto, new Percent(0.07m)); }
            }

            public decimal Vat7 {
                get { return ZwróćWartość(ZwracanaSuma.Vat, new Percent(0.07m)); }
            }            

            public decimal Netto12 {
                get { return ZwróćWartość(ZwracanaSuma.Netto, new Percent(0.12m)); }
            }

            public decimal Vat12 {
                get { return ZwróćWartość(ZwracanaSuma.Vat, new Percent(0.12m)); }
            }            

            public decimal Netto22 {
                get { return ZwróćWartość(ZwracanaSuma.Netto, new Percent(0.22m)); }
            }
            
            public decimal Vat22 {
                get { return ZwróćWartość(ZwracanaSuma.Vat, new Percent(0.22m)); }
            }
            
            public decimal NettoZW {
                get { return ZwróćWartośćZW(); }
            }
            
            public decimal Netto0 {
                get { return ZwróćWartość0(); }
            }

            public decimal NettoNP {
                get { return ZwróćWartośćNP(); }
            }

            // nowe stawki
            public decimal Netto8 {
                get { return ZwróćWartość(ZwracanaSuma.Netto, new Percent(0.08m)); }
            }
            
            public decimal Vat8 {
                get { return ZwróćWartość(ZwracanaSuma.Vat, new Percent(0.08m)); }
            }

            public decimal Netto23 {
                get { return ZwróćWartość(ZwracanaSuma.Netto, new Percent(0.23m)); }
            }
            
            public decimal Vat23 {
                get { return ZwróćWartość(ZwracanaSuma.Vat, new Percent(0.23m)); }
            }

            public decimal Netto4 {
                get { return ZwróćWartość(ZwracanaSuma.Netto, new Percent(0.04m)); }
            }

            public decimal Vat4 {
                get { return ZwróćWartość(ZwracanaSuma.Vat, new Percent(0.04m)); }
            }            
        }

        class NumerSystemowyComparer : IComparer {
            public int Compare(object obj1, object obj2) {
                Total t1 = (Total)obj1;
                Total t2 = (Total)obj2;
                string d1 = t1.Dokument.Definicja.Symbol;
                string d2 = t2.Dokument.Definicja.Symbol;
                int cmp = d1.CompareTo(d2);
                if (cmp != 0)
                    return cmp;
                string s1 = t1.Dokument.Numer.Pelny;
                string s2 = t2.Dokument.Numer.Pelny;
                return s1.CompareTo(s2);
            }
        }

        class NumerObcyComparer : IComparer {
            public int Compare(object obj1, object obj2) {
                Total t1 = (Total)obj1;
                Total t2 = (Total)obj2;
                string d1 = t1.Dokument.Definicja.Symbol;
                string d2 = t2.Dokument.Definicja.Symbol;
                int cmp = d1.CompareTo(d2);
                if (cmp != 0)
                    return cmp;                
                string s1 = t1.Dokument.Obcy.Numer;
                string s2 = t2.Dokument.Obcy.Numer;
                return s1.CompareTo(s2);
            }
        }

        class DataWystawieniaComparer : IComparer {
            public int Compare(object obj1, object obj2) {
                Total t1 = (Total)obj1;
                Total t2 = (Total)obj2;
                string de1 = t1.Dokument.Definicja.Symbol;
                string de2 = t2.Dokument.Definicja.Symbol;
                int cmp = de1.CompareTo(de2);
                if (cmp != 0)
                    return cmp;                
                Date d1 = t1.Dokument.Data;
                Date d2 = t2.Dokument.Data;
                return d1.CompareTo(d2);
            }
        }

        class DataOtrzymaniaComparer : IComparer {
            public int Compare(object obj1, object obj2) {
                Total t1 = (Total)obj1;
                Total t2 = (Total)obj2;
                string de1 = t1.Dokument.Definicja.Symbol;
                string de2 = t2.Dokument.Definicja.Symbol;
                int cmp = de1.CompareTo(de2);
                if (cmp != 0)
                    return cmp;                
                Date d1 = t1.Dokument.Obcy.DataOtrzymania;
                Date d2 = t2.Dokument.Obcy.DataOtrzymania;
                return d1.CompareTo(d2);
            }
        }

        class DataOperacjiComparer : IComparer {
            public int Compare(object obj1, object obj2) {
                Total t1 = (Total)obj1;
                Total t2 = (Total)obj2;
                string de1 = t1.Dokument.Definicja.Symbol;
                string de2 = t2.Dokument.Definicja.Symbol;
                int cmp = de1.CompareTo(de2);
                if (cmp != 0)
                    return cmp;
                Date d1 = t1.Dokument.DataOperacji;
                Date d2 = t2.Dokument.DataOperacji;
                return d1.CompareTo(d2);
            }
        }
        
        public RowCondition KategoriaCondition() {
            return new FieldCondition.GreaterEqual("Kategoria", KategoriaHandlowa.Zakup)
                    & new FieldCondition.LessEqual("Kategoria", KategoriaHandlowa.KorektaZakupu);
        }

        Soneta.Business.View PrzygotujView(Soneta.Handel.Forms.DokHandloweViewInfo.WParams pars) {
            HandelModule handel = HandelModule.GetInstance(pars);

            Soneta.Business.View view;

            //////////////////////////////////////////////////////////////////////
            /// Dla podmiotu
            /// 
            if (pars.Kontrahent != null) {
                SubTable st;
                if (pars.Magazyn != null) {
                    st = handel.DokHandlowe.WgKontrahent[pars.Kontrahent, pars.Magazyn];
                    if (pars.JestOkres)
                        st = new SubTable(st, pars.Okres);
                }
                else
                    st = handel.DokHandlowe.WgKontrahent[pars.Kontrahent];
                view = st.CreateView();
                if (pars.JestOkres && pars.Magazyn == null)
                    view.Condition &= new FieldCondition.Contain("Data", pars.Okres);
                if (pars.Definicja != null)
                    view.Condition &= new FieldCondition.Equal("Definicja", pars.Definicja);
            }

            ///////////////////////////////////////////////////////////////////////
            /// Definicja
            /// 
            else if (pars.Definicja != null && pars.Magazyn != null) {
                SubTable st = handel.DokHandlowe.WgDefinicja[pars.Definicja, pars.Magazyn];
                if (pars.JestOkres)
                    st = new SubTable(st, pars.Okres);
                view = st.CreateView();
            }

            //////////////////////////////////////////////////////////////////////
            /// Magazyn
            /// 
            else if (pars.Magazyn != null) {
                SubTable st = handel.DokHandlowe.WgMagazyn[pars.Magazyn];
                if (pars.JestOkres)
                    st = new SubTable(st, pars.Okres);

                view = st.CreateView();
            }

            //////////////////////////////////////////////////////////////////////
            /// Tylko okres
            /// 
            else {
                SubTable st = handel.DokHandlowe.WgDaty;
                if (pars.JestOkres)
                    st = new SubTable(st, pars.Okres);
                view = st.CreateView();
                if (pars.Definicja != null)
                    view.Condition &= new FieldCondition.Equal("Definicja", pars.Definicja);
            }

            view.Condition &= KategoriaCondition();

            if (!string.IsNullOrEmpty(pars.Seria))
                view.Condition &= new FieldCondition.Like("Seria", pars.Seria);

            if (!pars.Duplikaty)
                view.Condition &= new FieldCondition.Equal("Definicja.DuplikatWartosci", false);

            view.Condition &= DokHandlowe.UtwórzCondition("", pars.Stan);

            if (pars.WedługDaty == WedługDatyDokumentu.Terminu || pars.WedługDaty == WedługDatyDokumentu.PoTerminie) {
                if (pars.Okres != FromTo.All)
                    view.Condition &= new FieldCondition.Contain("Dostawa.Termin", pars.Okres.ValidDates);
                if (pars.WedługDaty == WedługDatyDokumentu.PoTerminie)
                    view.Condition &= !new RowCondition.Exists("RelacjaHandlowa", "Nadrzedny",
                        new FieldCondition.Equal("Typ", TypRelacjiHandlowej.Kopiowania) &
                        new FieldCondition.GreaterEqual("Rozliczenie", RozliczenieRelacji.CałośćWCzęściach));
            }

            switch (pars.Pozycje) {
                case FiltrPozycji.TylkoUsługi:
                    view.Condition &= new RowCondition.Exists("PozycjaDokHandlowego", "Dokument",
                        new FieldCondition.Equal("Towar.Typ", TypTowaru.Usługa));
                    view.Condition &= new RowCondition.Not(
                        new RowCondition.Exists("PozycjaDokHandlowego", "Dokument",
                            new FieldCondition.NotEqual("Towar.Typ", TypTowaru.Usługa)));
                    break;

                case FiltrPozycji.TylkoTowary:
                    view.Condition &= new RowCondition.Exists("PozycjaDokHandlowego", "Dokument",
                        new FieldCondition.NotEqual("Towar.Typ", TypTowaru.Usługa));
                    view.Condition &= new RowCondition.Not(
                        new RowCondition.Exists("PozycjaDokHandlowego", "Dokument",
                        new FieldCondition.Equal("Towar.Typ", TypTowaru.Usługa)));
                    break;

                case FiltrPozycji.ZUsługami:
                    view.Condition &= new RowCondition.Exists("PozycjaDokHandlowego", "Dokument",
                        new FieldCondition.Equal("Towar.Typ", TypTowaru.Usługa));
                    break;

                case FiltrPozycji.ZTowarami:
                    view.Condition &= new RowCondition.Exists("PozycjaDokHandlowego", "Dokument",
                        new FieldCondition.NotEqual("Towar.Typ", TypTowaru.Usługa));
                    break;
            }

            switch (pars.Potwierdzenie) {
                case FiltrPotwierdzenia.Niepotwierdzone:
                    view.Condition &= new FieldCondition.Equal("Potwierdzenie", PotwierdzenieDokumentuHandlowego.Niepotwierdzony);
                    break;

                case FiltrPotwierdzenia.Potwierdzone:
                    view.Condition &= new FieldCondition.Equal("Potwierdzenie", PotwierdzenieDokumentuHandlowego.Potwierdzony);
                    break;

                case FiltrPotwierdzenia.Zaakceptowane:
                    view.Condition &= new FieldCondition.Equal("Potwierdzenie", PotwierdzenieDokumentuHandlowego.Zaakceptowany);
                    break;

                case FiltrPotwierdzenia.Niezaakceptowane:
                    view.Condition &= new FieldCondition.NotEqual("Potwierdzenie", PotwierdzenieDokumentuHandlowego.Zaakceptowany);
                    break;
            }

            RowCondition rodzajCond = null;
            switch (pars.RodzajVAT) {
                case FiltrRodzajuVAT.Krajowe:
                    rodzajCond = new FieldCondition.Equal("RodzajPodmiotu", RodzajPodmiotu.Krajowy);
                    break;

                case FiltrRodzajuVAT.Unijne:
                    rodzajCond = new FieldCondition.Equal("RodzajPodmiotu", RodzajPodmiotu.Unijny);
                    break;
                case FiltrRodzajuVAT.UnijneTrójstronne:
                    rodzajCond = new FieldCondition.Equal("RodzajPodmiotu", RodzajPodmiotu.UnijnyTrójstronny);
                    break;
                case FiltrRodzajuVAT.UnijneRazem:
                    rodzajCond = new FieldCondition.Equal("RodzajPodmiotu", RodzajPodmiotu.Unijny)
                        | new FieldCondition.Equal("RodzajPodmiotu", RodzajPodmiotu.UnijnyTrójstronny);
                    break;

                case FiltrRodzajuVAT.Eksportowe:
                    rodzajCond = new FieldCondition.Equal("RodzajPodmiotu", RodzajPodmiotu.Eksportowy);
                    break;
                case FiltrRodzajuVAT.EksportowePodróżne:
                    rodzajCond = new FieldCondition.Equal("RodzajPodmiotu", RodzajPodmiotu.EksportowyPodróżny);
                    break;
                case FiltrRodzajuVAT.EksportoweRazem:
                    rodzajCond = new FieldCondition.Equal("RodzajPodmiotu", RodzajPodmiotu.Eksportowy)
                        | new FieldCondition.Equal("RodzajPodmiotu", RodzajPodmiotu.EksportowyPodróżny);
                    break;
            }
            if (rodzajCond != null)
                view.Condition &= new RowCondition.Exists("DaneKontrahenta", "Host", rodzajCond
                    & new FieldCondition.Equal("Typ", DokumentHandlowy.TypDanychKontrahent));

            view.Condition &= pars.FiltrRelacji.Condition;

            if (pars.OkresWpływu != FromTo.All)
                view.Condition &= new FieldCondition.GreaterEqual("Obcy.DataOtrzymania", pars.OkresWpływu.From) &
                                  new FieldCondition.LessEqual("Obcy.DataOtrzymania", pars.OkresWpływu.To);

            // TID: 13760;
            if (pars.OkresOperacji != FromTo.All)
                view.Condition &= new FieldCondition.GreaterEqual("DataOperacji", pars.OkresOperacji.From) &
                                  new FieldCondition.LessEqual("DataOperacji", pars.OkresOperacji.To);
            
            view.FilterCondition += new ConditionHandler(view_FilterCondition);

            return view;
        }
        
        private void view_FilterCondition(object sender, ConditionEventArgs args) {
            DokumentHandlowy dok = (DokumentHandlowy)args.Row;
            if (dok.Definicja.GetObjectRight() == AccessRights.Denied)
                args.Accepted = false;
        }
        
        protected void dc_ContextLoad(object sender, EventArgs e) {
            ReportHeader.Title += string.Format("|Okres {0}: {1}", CaptionAttribute.EnumToString(Parametry.WgOkresu), Parametry.Okres.ToString());
                                  
            Soneta.Handel.Forms.DokHandloweViewInfo.WParams pars = (Soneta.Handel.Forms.DokHandloweViewInfo.WParams)dc[typeof(Soneta.Handel.Forms.DokHandloweViewInfo.WParams)];

            switch (Parametry.WgOkresu)
            {
                case WgOkresu.Wpływu:
                    pars.Okres = FromTo.All;
                    pars.OkresOperacji = FromTo.All;
                    pars.OkresWpływu = Parametry.Okres;
                    break;
                case WgOkresu.Wystawienia:
                    pars.OkresWpływu = FromTo.All;
                    pars.OkresOperacji = FromTo.All;
                    pars.Okres = Parametry.Okres;
                    break;
                case WgOkresu.Operacji: // <-- TID: 13760;
                    pars.OkresWpływu = FromTo.All;
                    pars.Okres = FromTo.All;
                    pars.OkresOperacji = Parametry.Okres;
                    break;
            }

            // Mateusz - wybranie odpowiednich kolumn
            PrzygotujGrid( Parametry );
            
           Soneta.Business.View vw = PrzygotujView(pars);
            // Wyeliminowanie FN.
            vw.Condition &= new FieldCondition.NotEqual("Definicja.Intrastat", RodzajIntrastat.Przywóz);
            
            Hashtable result = new Hashtable();
            foreach(DokumentHandlowy dokument in vw) {
                if (dokument.Definicja.DuplikatWartosci || dokument.Anulowany) continue;
                
                Total t = (Total)result[dokument.ID];
                if (t == null) {
                    t = new Total(dokument);
                    result.Add(t.Dokument.ID, t);
                }
            }

            ArrayList lista = new ArrayList(result.Values);
            switch(Parametry.SortowanieWg) {
                case SortowanieWg.NumerSystemowy:
                    lista.Sort(new NumerSystemowyComparer());
                    break;
                case SortowanieWg.NumerObcy:
                    lista.Sort(new NumerObcyComparer());
                    break;
                case SortowanieWg.DataWystawienia:
                    lista.Sort(new DataWystawieniaComparer());
                    break;
                case SortowanieWg.DataOtrzymania:
                    lista.Sort(new DataOtrzymaniaComparer());
                    break;
                case SortowanieWg.DataOperacji:
                    lista.Sort(new DataOperacjiComparer());
                    break;                    
            }
            Grid.DataSource = lista;
        }

         private void PrzygotujGrid( ParametryBase param ) {
            if (param.DefinicjeStawekVAT != null && param.DefinicjeStawekVAT.Length != 0) {
                int index = 6;
                foreach (DefinicjaStawkiVat defVAT in param.DefinicjeStawekVAT) {
                    string stawka = defVAT.Kod.TrimEnd( new char[] { '%' } );

                    bool firstAdded = false;
                    // sprawdzić czy total zawiera property
                    if( typeof( Total ).GetProperty( "Netto"+stawka ) != null ) {
                        // netto
                        GridColumn gcNetto = new GridColumn();
					    gcNetto.Caption = string.Format("Netto {0}", defVAT.Kod);
					    gcNetto.Format = "{0:n}";
					    gcNetto.Align = System.Web.UI.WebControls.HorizontalAlign.Right;
					    gcNetto.Total = Soneta.Web.Total.Sum;
                        gcNetto.DataMember = "Netto"+stawka;
					    Grid.Columns.Insert(index++, gcNetto);
                        firstAdded = true;
                    }

                    if( typeof( Total ).GetProperty( "Vat"+stawka ) != null ) {
                        GridColumn gcVAT = new GridColumn();
					    gcVAT.Caption = string.Format("VAT {0}", defVAT.Kod);
					    gcVAT.Format = "{0:n}";
					    gcVAT.Align = System.Web.UI.WebControls.HorizontalAlign.Right;
					    gcVAT.Total = Soneta.Web.Total.Sum;
					    gcVAT.DataMember = "Vat"+stawka;
                        gcVAT.RowSpan = 2;
                        Grid.Columns.Insert(index++, gcVAT);
                    } else if ( firstAdded ) {
                        GridColumn gcVAT = new GridColumn();
                        gcVAT.RowSpan = 2;
                        Grid.Columns.Insert(index++, gcVAT);
                    }
                }
            }
        }

    </script>

    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form id="Form1" method="post" runat="server">
    <ea:DataContext ID="dc" runat="server" OnContextLoad="dc_ContextLoad" Landscape="true"></ea:DataContext>
    <eb:ReportHeader ID="ReportHeader" runat="server" Title="Dokumenty i zestawienie VAT zakupu">
    </eb:ReportHeader>
    <ea:Grid ID="Grid" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel" RowsInRow="3"
             GroupLine="Definicja: {0}" GroupData0="Dokument.Definicja.Symbol" ShowGroupSum="true">
        <Columns>
            <ea:GridColumn runat="server" Width="4" Align="Right" DataMember="#" Caption="Lp." RowSpan="3">
            </ea:GridColumn>
            <ea:GridColumn runat="server" Align="Left" DataMember="Dokument.Numer.Pelny" Caption="Numer" RowSpan="2">
            </ea:GridColumn>
            <ea:GridColumn runat="server" Align="Left" DataMember="Dokument.Kontrahent" Caption="Kontrahent"
                Total="Info" ColSpan="4">
            </ea:GridColumn>            
            <ea:GridColumn runat="server" Align="Left" DataMember="Dokument.Obcy.Numer" Caption="Numer obcy" RowSpan="2"
                Width="10">
            </ea:GridColumn>
            <ea:GridColumn runat="server" Align="Left" DataMember="Dokument.Data" Caption="Data wystawienia" RowSpan="2"
                Width="13">
            </ea:GridColumn>
            <ea:GridColumn runat="server" Align="Left" DataMember="Dokument.Obcy.DataOtrzymania" Caption="Data otrzymania" RowSpan="2"
                Width="13">
            </ea:GridColumn>
                        
            <ea:GridColumn runat="server" Align="Right" DataMember="Dokument.Suma.Netto" Caption="Netto"
                Width="12" Total="Sum">
            </ea:GridColumn>
            <ea:GridColumn runat="server" Align="Right" DataMember="Dokument.Suma.VAT" Caption="VAT" Width="12"
                Total="Sum">
            </ea:GridColumn>
            <ea:GridColumn runat="server" Align="Right" DataMember="Dokument.Suma.Brutto" Caption="Brutto"
                Width="12" Total="Sum">
            </ea:GridColumn>            
        </Columns>
    </ea:Grid>
    <eb:ReportFooter ID="ReportFooter" runat="server">
    </eb:ReportFooter>
    </form>
</body>
</html>